//
//  CountdownUnit.swift
//  death_app Watch App
//
//  Created by Task Master on 2025-09-16.
//

import SwiftUI

struct CountdownUnit: View {
    let value: Int
    let unit: String
    let accessibilityLabel: String
    
    var body: some View {
        VStack(spacing: 2) {
            Text("\(value)")
                .font(.system(.title3, design: .monospaced, weight: .semibold))
                .foregroundColor(.primary)
                .frame(minWidth: 28, alignment: .center)
                .accessibility(hidden: true)
            
            Text(unit)
                .font(.system(.caption2, design: .monospaced))
                .foregroundColor(.secondary)
                .accessibility(hidden: true)
        }
        .padding(.horizontal, 4)
        .padding(.vertical, 2)
        .background(
            RoundedRectangle(cornerRadius: 6)
                .fill(Color.gray)
        )
        .accessibility(label: Text("\(value) \(accessibilityLabel)"))
        .accessibility(addTraits: .isStaticText)
    }
}

#Preview {
    HStack(spacing: 8) {
        CountdownUnit(value: 42, unit: "Y", accessibilityLabel: "Years")
        CountdownUnit(value: 3, unit: "M", accessibilityLabel: "Months")
        CountdownUnit(value: 15, unit: "D", accessibilityLabel: "Days")
    }
    .padding()
}
